% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{qc}
\alias{qc}
\alias{subst}
\title{Create vector of characters from unquoted strings (variable names)}
\usage{
qc(...)

subst(...)
}
\arguments{
\item{...}{characters in \code{subst}/unquoted names of variables in \code{qc}}
}
\value{
Vector of characters
}
\description{
In many cases one need to address variables in list/data.frame in such 
manner: \code{dfs[ , c("var1", "var2", "var3")]}. \code{qc} ("quoted c") is a
shortcut for the such cases to reduce keystrokes. With \code{qc} you can write:
\code{dfs[ , qc(var1, var2, var3)]}.
\code{subst} is simple string interpolation function. It searches in its
arguments expressions in backticks (`), evaluate it and substitute it with
result of evaluation. See examples.
}
\examples{

## qc
qc(a, b, c)
identical(qc(a, b, c), c("a", "b", "c"))

mtcars[, qc(am, mpg, gear)]

## subst
i = 1:5
subst("q`i`")

i = 1:3
j = 1:3
subst("q1_`i`_`j`")

data(iris)
subst("'iris' has `nrow(iris)` rows.")
}

