% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gencormat.R
\name{gencorrelationmat}
\alias{gencorrelationmat}
\title{Function that generates a correlation matrix taking as input number of factors for each level, factor or factors that present correlation and rho value or values.}
\usage{
gencorrelationmat(mean_matrix, rho, label_list = NULL, withinf, nlfA, nlfB)
}
\arguments{
\item{mean_matrix}{Matrix - cell mean value matrix}

\item{rho}{Vector length 1 or 2, or 2 by 2 matrix - Controls how the correlation and hence de covariance matrix is built. See details.}

\item{label_list}{List length 2 - Names of factor levels}

\item{withinf}{Character- Factor for which measurements are repeated, options are NULL, "fA", "fB" and "both". If NULL (default) independent measurements will be considered.}

\item{nlfA}{Integer - number of levels of factor A}

\item{nlfB}{Integer - number of levels of factor B}
}
\value{
Correlation matrix
}
\description{
May be run independently or internally as part of 'calculate_mean_matrix'.
}
\details{
If a repeated measures experiment is intended 'withinf' must be set to "fA", "fB" or "both", depending on which is the "within" factor. If 'rho' is a vector length 1, the within subject correlation
will be constant for the factor defined in 'withinf'. If 'rho' is a vector length 2 and 'withinf' is either "fA" or "fB" a correlation gradient will be created from the first to second value of
'rho'. If 'rho' is a vector length 2 and 'withinf="both"', the first element of 'rho' will be the correlation within factor A, while the second element will be the correlation within factor B. If
'rho' is a 2*2 matrix, only possible if 'withinf="both"', a correlation gradient will be created across rows of 'rho' for each of the factors.
}
