% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosethres.R
\name{choosethres}
\alias{choosethres}
\title{Function for heuristically choosing the domain where extreme value theory can be applied}
\usage{
choosethres(data, thresh, guess = c(1, 0.1), plots = 1:3, R = 200,
  ncpus = 1)
}
\arguments{
\item{data}{a numeric vector containing the observation used for verification}

\item{thresh}{vector of thresholds to try}

\item{guess}{starting values for GPD's sigma and xi (0<xi<1)}

\item{plots}{which parameter plots do you want}

\item{R}{number of bootstrap estimates for confidence intervals}

\item{ncpus}{if you want to make bootstrap on several cores}
}
\value{
three plots summarizing the stability of the parameters to threshold. The starting threshold admits kappa=1 and its confidence interval ;
according Papastathopoulos & Tawn (2013)

a list with thresholds used, GP parameters and CIs, p-values of Cramer von Mises test (accordance of thresholded data with GP), optimal threshold and xi.
}
\description{
Function for heuristically choosing the domain where extreme value theory can be applied
}
