% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recodeye.R
\name{recodeye}
\alias{recodeye}
\title{Recode eyes}
\usage{
recodeye(
  x,
  to = c("r", "l"),
  eyecodes = list(c("r", "re", "od", "right"), c("l", "le", "os", "left")),
  numcode = NULL
)
}
\arguments{
\item{x}{vector of strings}

\item{to}{to which codes. Right coded first.}

\item{eyecodes}{list of substrings which should be converted to
right and left eyes - first vector for right, then for left eyes}

\item{numcode}{if you have numeric coding which is not 0:1 or 1:2 for
right:left, specify it here.}
}
\value{
Character vector
}
\description{
recoding eyes to "r" and "l"
}
\examples{
x <- c("r", "re", "od", "right", "l", "le", "os", "left")
recodeye(x)
## chose the resulting codes
recodeye(x, to = c("right", "left"))
x <- 1:2
recodeye(x)
## or, if right is coded with 2)
recodeye(x, numcode = 2:1)

}
\seealso{
Other string matching functions: 
\code{\link{getElem}},
\code{\link{set_codes}()},
\code{\link{sort_substr}()},
\code{\link{str_func_facs}}
}
\concept{string matching functions}
