% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORGANISE__functions.R
\name{organise.behavioural.base}
\alias{organise.behavioural.base}
\title{Save RT and Accuracy split by specified columns.}
\usage{
organise.behavioural.base(fixreport_df, grouping_column_list,
  response_period_start = "")
}
\arguments{
\item{fixreport_df}{Fixation report.}

\item{grouping_column_list}{List of columns to split by.}

\item{response_period_start}{Message that starts the RT timer.}
}
\value{
Summarised behavioural information as a data.table.
}
\description{
Save RT and Accuracy split by specified columns.
}
\examples{

data(fixationreport)
data(messagereport)

# REPLACE SPACES IN MESSAGES
messagereport <- organise.message.replace_spaces(messagereport)

# TAKE A LOOK
print(organise.message.descriptives(messagereport))

# MARKUP
fixationreport <- organise.message.markup(message_df=messagereport, 
fixreport_df = fixationreport, message="DISPLAY_START")

fixationreport <- organise.message.markup(message_df=messagereport, 
fixreport_df = fixationreport, message="DISPLAY_CHANGE")

# NOW DO ACCURACY AND RT MARKUP
fixationreport <- organise.responses.markup(fixationreport, "CORRECT_RESPONSE")

# NOW MARK UP FIXATION CONTINGENCIES
fixationreport<-organise.message.fix_contingencies(fixationreport, 
list("DISPLAY_START", "DISPLAY_CHANGE", "RESPONSE_TIME"))

# SET UP TRUE RT
fixationreport[,TRUE_RT:=RESPONSE_TIME-DISPLAY_START,]

behaviouralData <- analyse.behavioural.data(fixationreport,
     aggregation_column_list = list('TRIALTYPE_TEXT'))

# RANDOM TRIAL TO CHECK THINGS OUT
print(organise.checks.random_trial(fixationreport))

# FIX CONTINGENCIES
print(organise.contingencies.descriptives(fixationreport))

# REMOVE MISSING EVENTS - HERE, TRIALS WHICH LACKED A RESPONSE
messageRemovals <- organise.message.removals(fixreport_df=fixationreport, 
    required_message_list=list("DISPLAY_CHANGE", "RESPONSE_TIME"))

# LOOK AT MESSAGE REMOVALS
print(messageRemovals[[1]])

# GRAB THE FIXATION REPORT WITH TRIALS REMOVED
fixMessagesRemoved <- messageRemovals[[2]]

# THIS SHOWS WE HAVE NO UNCLASSIFIED FIXATIONS, GOOD!
print(organise.contingencies.descriptives(fixMessagesRemoved))

# GET A BEHAVIOURAL DATASET FOR ANALYSES AND SAVING ETC.
behavDT<- organise.behavioural.base(fixreport_df = fixMessagesRemoved, 
   list( 'TRIALTYPE_TEXT'), response_period_start="DISPLAY_START")
}
