% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORGANISE__functions.R
\name{organise.responses.markup}
\alias{organise.responses.markup}
\title{Mark up responses into a fixation report.}
\usage{
organise.responses.markup(fixreport_df, correct_answer_column)
}
\arguments{
\item{fixreport_df}{Fixation report}

\item{correct_answer_column}{The column in the fixation report containing the correct button response number (1-7).}
}
\value{
Updated fixation report as a data.table.
}
\description{
Mark up responses into a fixation report.
}
\examples{

data(fixationreport)
data(messagereport)

# REPLACE SPACES IN MESSAGES
messagereport <- organise.message.replace_spaces(messagereport)

# TAKE A LOOK
print(organise.message.descriptives(messagereport))

# MARKUP
fixationreport <- organise.message.markup(message_df=messagereport, 
                                          fixreport_df = fixationreport, message="DISPLAY_START")

fixationreport <- organise.message.markup(message_df=messagereport, 
                                          fixreport_df = fixationreport, message="DISPLAY_CHANGE")

# NOW DO ACCURACY AND RT MARKUP
fixationreport <- organise.responses.markup(fixationreport, "CORRECT_RESPONSE")
}
