% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_variables.R
\name{extract_variables}
\alias{extract_variables}
\alias{extract_variables.data.frame}
\alias{extract_variables.eyelinkRecording}
\title{Extract variables}
\usage{
extract_variables(object)

\method{extract_variables}{data.frame}(object)

\method{extract_variables}{eyelinkRecording}(object)
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with events,
i.e., \code{events} slot of the \code{\link{eyelinkRecording}} object.}
}
\value{
Object of the same time as input, i.e., either a \code{\link{eyelinkRecording}} object
with an additional \code{variables} slot or a data.frame with variables' information. See
\code{\link{eyelinkRecording}} for details.
}
\description{
Extracts variables from the \code{events} table of the \code{\link{eyelinkRecording}} object.
Normally, you don't need to call this function yourself,
as it is called during the \code{\link{read_edf}} with default settings
(\emph{e.g.}, \code{import_variables = TRUE}).
}
\examples{
data(gaze)

# by passing the recording
gaze <- extract_variables(gaze)

# by passing events table
variables <- extract_variables(gaze$events)
}
\seealso{
read_edf, eyelinkRecording
}
