% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plot.R
\name{model_plot}
\alias{model_plot}
\title{model_plot}
\usage{
model_plot(
  data,
  x,
  actual,
  fitted,
  facet_x = NULL,
  point_size = 2,
  res_bins = NA_real_,
  size = 11
)
}
\arguments{
\item{data}{A data.frame.}

\item{x}{A named character value. Evaluates to a column.}

\item{actual}{A character value. Evaluates to a column.}

\item{fitted}{A character value. Evaluates to a column.}

\item{facet_x}{A character value. Evaluates to a column.}

\item{point_size}{Numeric. Default is 2.}

\item{res_bins}{Number of bins in the residual distribution. Default value
(NA) doesn't show the distribution.}

\item{size}{theme size for \code{use_theme()}. Default is 14.}
}
\value{
A ggplot object.
}
\description{
model_plot
}
\examples{
y = rnorm(26)
df = data.frame(ID = 1:26, actual = y + rnorm(26), fitted = y, id = letters)
model_plot(df, "ID", "actual", "fitted")
model_plot(df, "id", "actual", "fitted")
model_plot(df, "ID", "actual", "fitted", res_bins = 10)
model_plot(df, "id", "actual", "fitted", res_bins = 10)
}
