% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conf_int.R
\name{Conf_int}
\alias{Conf_int}
\title{Confidence Intervals For Change Point Estimator}
\usage{
Conf_int(fdobj, h = 0, kern_type = "BT", alpha = 0.05, ...)
}
\arguments{
\item{fdobj}{Functional data object, class of \code{"fd"}}

\item{h}{Bandwidth parameter to estimate the long run covariance operator.}

\item{kern_type}{Kernel to be used for the estimation of the long run covariance function}

\item{alpha}{Nominal level used to construct the confidence intervals}

\item{...}{Further arguments to pass}
}
\value{
\item{\code{Lower CI}}{
Lower Confidence Band
}
\item{\code{Estimate}}{
Estimated change point location
}
\item{\code{Upper CI}}{
Upper Confidence Band
}
}
\description{
A change point in the mean function of functional data is estimated, and for a user selected level
aconfidence interval is computed using the fully functional procedure introduced in Aue, Rice and Sonmez (2017+).
}
\examples{
fdata1 = fun_AR(n=100, nbasis=21, order=1, kappa=0.5)
Conf_int(fdata1, h=2)
}
\references{
Aue, A., Rice, G. & O. Sonmez   (2017+), \emph{ Detecting and dating structural breaks ¨
in functional data without dimension reduction}, (https://arxiv.org/pdf/1511.04020.pdf)
}
\seealso{
\code{\link{LongRun}} \code{\link{opt_bandwidth}} \code{\link{change_FF}}
}
