% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_FF.R
\name{change_FF}
\alias{change_FF}
\title{Change Point Analysis Of Functional Data Without Dimension Reduction (Fully Functional)}
\usage{
change_FF(fdobj, M = 1000, h = 0, plot = FALSE, ...)
}
\arguments{
\item{fdobj}{A functional data object of class '\code{fd}'}

\item{M}{Number of monte carlo simulations used to get the critical values. The default value is \code{M=1000}}

\item{h}{The window parameter for the estimation of the long run covariance kernel. The default
value is \code{h=0}, i.e., it assumes iid data}

\item{plot}{If \code{TRUE} plot of the functional data before and after the estimated change and plot of the
estimated change function is given}

\item{...}{Further arguments to pass}
}
\value{
\item{\code{pvalue}}{
Approximate p value for testing whether there is a significant change in the mean function
}
\item{\code{change}}{
Estimated change location
}
\item{\code{DataBefore}}{
Data before the estimated change
}
\item{\code{DataAfter}}{
Data after the estimated change
}
\item{\code{MeanBefore}}{
Mean function before the estimated change
}
\item{\code{MeanAfter}}{
Mean function after the estimated change
}
\item{\code{change_fun}}{
Estimated change function
}
}
\description{
This function tests whether there is a significant change in the mean function of the functional data, and it will
give an estimate for the location of the change. The procedure is based on the standard L-2 norm and hence does not depend on any dimension
reduction technique such as fPCA.
}
\details{
This function dates and detects changes in the mean function of functional data using a fully functional technique that does not
dependent on dimension reduction. For more details, see Aue, Rice, Sonmez (2017+)
}
\examples{
# generate functional data
fdata = fun_IID(n=100, nbasis=21)
# insert an artifiical change
data_c = insert_change(fdata, k=21, change_location = 0.5, SNR=1)$fundata
change_FF(data_c)$change



}
\references{
Aue A., Rice G., Sonmez O. (2017+), \emph{Detecting and dating structural breaks in
functional data without dimension reduction} (https://arxiv.org/pdf/1511.04020.pdf)
}
\seealso{
\code{\link{change_fPCA}}
}
