% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00-utils.R
\name{get_path_list}
\alias{get_path_list}
\title{Get the paths of branches in a list}
\usage{
get_path_list(list_obj, .map_list = NULL)
}
\arguments{
\item{list_obj}{R list object to be evaluated}

\item{.map_list}{non usable parameter. This parameter is only there to ensure
recursivity. Any modification of this object returns NULL}
}
\value{
A tibble containing all the paths of each element of the list and the
class of each leaf (can be a list, or R objects).
}
\description{
Function that recursively go through a list object and store in a tibble the
path of each element in the list. The paths can be after that edited and
accessed using \code{\link[=parceval]{parceval()}} for example.
}
\examples{
{

library(dplyr)
get_path_list(
  list(
    tibble = iris,
    list = list(t1 = mtcars, t2 = tibble(iris)),
    char = "foo"))

}

}
\seealso{
\code{\link[=parceval]{parceval()}}
}
