% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagwalk.R
\name{RW}
\alias{RW}
\alias{report.RW}
\alias{NAIVE}
\alias{SNAIVE}
\title{Random walk models}
\usage{
RW(formula, ...)

NAIVE(formula, ...)

SNAIVE(formula, ...)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{...}{Not used.}
}
\value{
A model specification.
}
\description{
\code{RW()} returns a random walk model, which is equivalent to an ARIMA(0,1,0)
model with an optional drift coefficient included using \code{drift()}. \code{naive()} is simply a wrapper
to \code{rwf()} for simplicity. \code{snaive()} returns forecasts and
prediction intervals from an ARIMA(0,0,0)(0,1,0)m model where m is the
seasonal period.
}
\details{
The random walk with drift model is \deqn{Y_t=c + Y_{t-1} + Z_t}{Y[t]=c +
Y[t-1] + Z[t]} where \eqn{Z_t}{Z[t]} is a normal iid error. Forecasts are
given by \deqn{Y_n(h)=ch+Y_n}{Y[n+h]=ch+Y[n]}. If there is no drift (as in
\code{naive}), the drift parameter c=0. Forecast standard errors allow for
uncertainty in estimating the drift parameter (unlike the corresponding
forecasts obtained by fitting an ARIMA model directly).

The seasonal naive model is \deqn{Y_t= Y_{t-m} + Z_t}{Y[t]=Y[t-m] + Z[t]}
where \eqn{Z_t}{Z[t]} is a normal iid error.
}
\section{Specials}{


\subsection{lag}{
The \code{lag} special is used to specify the lag order for the random walk process.
If left out, this special will automatically be included.

\preformatted{
lag(lag = NULL)
}

\tabular{ll}{
\code{lag}        \tab The lag order for the random walk process. If \code{lag = m}, forecasts will return the observation from \code{m} time periods ago. This can also be provided as text indicating the duration of the lag window (for example, annual seasonal lags would be "1 year").
}
}

\subsection{drift}{
The \code{drift} special can be used to include a drift/trend component into the model. By default, drift is not included unless \code{drift()} is included in the formula.

\preformatted{
drift(drift = TRUE)
}

\tabular{ll}{
\code{drift}      \tab If \code{drift = TRUE}, a drift term will be included in the model.
}
}
}

\examples{
library(tsibbledata)
aus_production \%>\%
  model(rw = RW(Beer ~ drift()))

as_tsibble(Nile) \%>\%
  model(NAIVE(value))
library(tsibbledata)
aus_production \%>\%
  model(snaive = SNAIVE(Beer ~ lag("year")))
}
\seealso{
\href{https://otexts.com/fpp3/simple-methods.html}{Forecasting: Principles and Practices, Some simple forecasting methods (section 3.2)}
}
