% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabric_drawing.R
\name{fabric_drawing}
\alias{fabric_drawing}
\title{Create a canvas element for drawing}
\usage{
fabric_drawing(
  cid,
  cwidth = 800,
  cheight = 600,
  cfill = "#FFFFFF",
  drawingWidth = 2,
  drawingColor = "#1E1E1E",
  gumSize = 10
)
}
\arguments{
\item{cid}{the id of the canvas element}

\item{cwidth}{the width of the canvas element}

\item{cheight}{the height of the canvas element}

\item{cfill}{the color of the canvas element. Default to #FFFFFF (white)}

\item{drawingWidth}{the width of the drawing output. Default to 2}

\item{drawingColor}{the color of the drawing output. Default to #1E1E1E (black)}

\item{gumSize}{specify the size of the gum. Defaults to 10}
}
\value{
an HTML canvas element
}
\description{
Create a canvas element for drawing
}
\examples{
if (interactive()) {

ui <- fluidPage(

   use_fabric(),

   h1("Draw some stuff here"),

   fabric_drawing(cid = "canvas1")

   )

server <- function(input, output) {}

shinyApp(ui = ui, server = server)

}
}
