\name{MFA}
\alias{MFA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
function performing a Multiple Factor Analysis in the sense of Escofier-Pages on a given data table or on (simulated) data streams.
}
\description{
This function permits user to perform fast Multiple Factor Analysis on (high dimensional on-line) data.  

Using stochastic processes, several estimation may be calculated depending on the user goals:
principal factors, principal axes, eigenvalues and correlation coefficients between the original
variables and the principal factors can be computed and updated recursively.
 
Moreover, graphics may be printed in order to give a better visualization and meaning/interpretation of
the data. It's possible to get meanningful 2D visualizations : the observations are projected on the plans generated
 by direction vectors of the principal axes.  Correlation circles that show a
projection of the initial variables in the factors space are also available.
}
\usage{
MFA(data,groups,stream=TRUE,nb_fact,principal_factors=TRUE,principal_axes=FALSE,
eigenvalues=FALSE,corr=FALSE,graphics=FALSE,data_init,exec_time,print_step)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{matrix : data to be analysed. The columns will represent your variables and 
the rows will represent your observations (sometimes called records, subjects or cases).
If you consider on-line data (\code{stream=TRUE}), of course all the observations are not available at the
beginning of the analysis. Thus, each observation (line of the matrix) will be treated 
individually (and then forgotten) to simulate the data stream.       
}
  \item{groups}{vector : each component of \code{groups} gives the dimension/length of the associated group of variables.
}
  \item{stream}{boolean : stream=TRUE if you consider data streams; stream=FALSE otherwise.

}
  \item{nb_fact}{integer : number of elements to be calculated. For instance, if you need
 the three first principal factors, nb_fact=3

}
  \item{principal_factors}{ boolean : principal_factors=TRUE if you need the value of some first
principal factors; principal_factors=FALSE otherwise.
}
  \item{principal_axes}{ boolean : principal_axes=TRUE if you need the value of some first
principal axes; principal_axes=FALSE otherwise.
}
  \item{eigenvalues}{boolean : eigenvalues=TRUE if you need the value of some first
eigenvalues; eigenvalues=FALSE otherwise.
}
  \item{corr}{boolean : corr=TRUE if you need the value of correlation coefficient between the
original variables and some first principal factors; corr=FALSE otherwise.
}
  \item{data_init}{integer : this argument is only relevant when stream=TRUE. It represents the number
of data used to intialize the analysis. It must be at least equal to the number of columns of the dataset.

}
  \item{exec_time}{real : execution time. If stream=TRUE, the analysis will stop when one of
these two events happen: all the data have been taken into account or execution time achieved. Otherwise, it's the execution time of \code{\link{MFA_iter}}.
}
  \item{graphics}{boolean : if graphics=TRUE, 2D visualizations will be plotted, representing
projections of the observations on all the plans generated by the \code{nb_fact} direction vectors
of the principal axes. If corr=TRUE, correlation circles that show a projection of the initial variables in the factors
spaces will also be plotted; if graphics=FALSE, no graphics will be plotted.


N.B. : For the fist kind of graphics, a gradation of grey was chosen to represent the "age" of the observations. The darker a point is, the newer the observation is. This coding
is meaningful for a data stream (stream=TRUE). if stream=FALSE, the "age" concept is less relevant: in this configuration, the darker a point is, the lower the observation is in
the matrix (database).  
}
  \item{print_step}{integer : this argument is only relevant when stream=TRUE. Each time that a new observation
is taken into account, a new estimation of the principal factors (or principal axes, ...) is computed but not
necessarily printed: it will be printed only every \code{print_step} observations.  
}
}
\details{
MFA is assumed here to be performable only on groups composed of quantitative variables.
}
\value{
results that user needs (principal factors, principal axes, eigenvalues and correlation coefficients)
}
\references{
Multiple Factor Analysis: Main Features and Application to Sensory Data, Jérôme Pagès, 2004.
Approximation stochastique en analyse factorielle multiple, Jean-Marie Monnez, Publications de l'Institut de Statistique de l'Université de Paris L, 3 (2006) 27-45
}
\author{
BAR Romain, Université de Lorraine, IECL, INRIA: BIGS group.
}
\seealso{ 
\code{\link{MFA_iter}}
}

\examples{

data(vins_de_loire)
MFA(rbind(vins_de_loire,vins_de_loire,vins_de_loire),c(5,3,10,9,2),stream=TRUE,3,
principal_factors=TRUE,principal_axes=TRUE,eigenvalues=TRUE,corr=TRUE,30,graphics=TRUE,
1,print_step=10)

}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{multiple factor analysis}

