# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Frequency
#' @description Frequency Class
#' @format An \code{R6Class} generator object
#' @field name  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
Frequency <- R6::R6Class(
  'Frequency',
  public = list(
    `name` = NULL,
    initialize = function(`name`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
    },
    toJSON = function() {
      FrequencyObject <- list()
      if (!is.null(self$`name`)) {
        FrequencyObject[['name']] <-
          self$`name`
      }

      FrequencyObject
    },
    fromJSON = function(FrequencyJson) {
      FrequencyObject <- jsonlite::fromJSON(FrequencyJson)
      if (!is.null(FrequencyObject$`name`)) {
        self$`name` <- FrequencyObject$`name`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(FrequencyJson) {
      FrequencyObject <- jsonlite::fromJSON(FrequencyJson)
      self$`name` <- FrequencyObject$`name`
      self
    }
  )
)
