% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{fairTwins}
\alias{fairTwins}
\title{Fair Twin Inspection convenience function.}
\usage{
fairTwins(x, train.id = seq_len(nrow(x$train)), test.id = NULL, cols = NULL)
}
\arguments{
\item{x}{Object of class \code{fairadapt}, a result of an adaptation
procedure.}

\item{train.id}{A vector of indices specifying which rows of the training
data should be displayed.}

\item{test.id}{A vector of indices specifying which rows of the test
data should be displayed.}

\item{cols}{A \code{character} vector, subset of \code{names(train.data)},
which specifies which subset of columns is to be displayed in the result.}
}
\value{
A \code{data.frame}, containing the original and adapted values
of the requested individuals. Adapted columns have \code{_adapted} appended
to their original name.
}
\description{
Fair Twin Inspection convenience function.
}
\examples{
uni.adj.mat <- array(0, dim = c(4, 4))
colnames(uni.adj.mat) <- rownames(uni.adj.mat) <-
  c("gender", "edu", "test", "score")

uni.adj.mat["gender", c("edu", "test")] <-
  uni.adj.mat["edu", c("test", "score")] <-
  uni.adj.mat["test", "score"] <- 1L

FA <- fairadapt(score ~ .,
  train.data = uni_admission[1:100, ],
  test.data = uni_admission[101:150, ],
  adj.mat = uni.adj.mat, prot.attr = "gender")

fairTwins(FA, train.id = 1:5)
}
