% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-family.R
\name{fit.family}
\alias{fit.family}
\title{Fit family}
\usage{
fit.family(
  x,
  w = rep(1, length(x)),
  family = "huber",
  spread.fun = weighted.mad,
  eps = .Machine$double.eps
)
}
\arguments{
\item{x}{a numeric vector of data}

\item{w}{a numeric vector of weights}

\item{family}{the location family; currently only allows 'huber' for Huber family}

\item{spread.fun}{a function used for the spread of \code{x}; must accept data \code{x} and
weights \code{w} (in that order), and return a numeric}

\item{eps}{a numerical tolerance parameter}
}
\value{
An object of class \code{fit.family}; a data frame with the following columns:
\item{mu}{the fitted values}
\item{lambda}{the thresholding parameter}
}
\description{
Fits a family of centers.
}
\examples{
fit <- fit.family(MASS::galaxies)
plot(fit)
}
\author{
Ryan Thompson <ryan.thompson@monash.edu>
}
