/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.LPX;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.lp.SOS2Primitive;
import jfm.model.BadModelException;
import jfm.model.Types;

public abstract class BoundaryComponent
extends ModelComponent {
    private final double historicalLength;
    private final double discountRate;
    private final double maintainCost;
    private final double maxLength;
    protected MatrixVariable lengthCounter = null;
    private final Types.ObjectiveType otype;
    private final ModelComponent.MCType mctype;
    protected final SOS2Primitive profit;

    public BoundaryComponent(ModelComponent.MCType mctype_, Types.ObjectiveType otype_, double maxLen_, double hist, double createCost, double destCost, double maintain, double discountRate_) {
        super(mctype_);
        this.mctype = mctype_;
        this.otype = otype_;
        this.historicalLength = hist;
        this.maxLength = maxLen_;
        if (this.historicalLength > this.maxLength) {
            throw new Error("Historical Length cannot be greater than max hedge length");
        }
        this.discountRate = discountRate_;
        this.maintainCost = maintain;
        double[] xProfitVals = new double[]{-this.historicalLength, 0.0, this.maxLength};
        double[] yProfitVals = new double[]{-destCost * this.historicalLength * this.discountRate, -this.maintainCost * this.historicalLength, -this.maintainCost * this.maxLength - createCost * this.discountRate * (this.maxLength - this.historicalLength)};
        this.profit = new SOS2Primitive("HedgerowProfit", Types.ObjectiveType.PROFIT, xProfitVals, yProfitVals);
        this.profit.registerParent(this);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        this.requireObjective(this.otype);
    }

    int getBoundaryCounterColumn() {
        return this.lengthCounter.column();
    }

    public double getSolvedLength() {
        double plen = this.profit.getSolvedValue();
        return plen + this.historicalLength;
    }

    public ModelComponent copy() {
        return null;
    }

    protected void initializeStructure() throws BadModelException {
        MatrixVariable newVariable = new MatrixVariable(1.0, 0.0, 0.0, LPX.LPX_LO, LPX.LPX_CV, this.matrix.numCols(), this.otype);
        newVariable.setTag("boundarylength " + this.mctype.toString());
        this.matrix.addVariable(newVariable);
        this.lengthCounter = newVariable;
        this.profit.initializeStructure();
    }

    protected String name() {
        return null;
    }

    public void setFormulaVariables() {
    }

    protected void updateStructure() {
    }
}

