/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.model.Crop;
import jfm.model.CropYear;
import jfm.model.CroppingComponent;
import jfm.model.Farm;
import jfm.model.Location;
import jfm.model.Operation;
import jfm.model.Types;
import jfm.model.Worker;
import jfm.utils.MathPrint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkersComponent
extends ModelComponent {
    private static String constraintTag = "Workers";
    private final HashMap<Types.WorkerType, HashMap<Types.WorkerSubType, Worker>> workers;

    @Override
    public String name() {
        return "workers";
    }

    @Override
    public void setFormulaVariables() {
    }

    @Override
    public WorkersComponent copy() {
        HashMap<Types.WorkerSubType, Worker> wkrscpy = new HashMap<Types.WorkerSubType, Worker>();
        for (Types.WorkerType wt : this.workers.keySet()) {
            HashMap<Types.WorkerSubType, Worker> oldmap = this.workers.get((Object)wt);
            for (Types.WorkerSubType wst : oldmap.keySet()) {
                wkrscpy.put(wst, oldmap.get((Object)wst).copy());
            }
        }
        return new WorkersComponent(wkrscpy);
    }

    public WorkersComponent(HashMap<Types.WorkerSubType, Worker> workers_) {
        super(ModelComponent.MCType.WORKERS);
        this.requireObjective(Types.ObjectiveType.PROFIT);
        this.addConstraintBuilder(new ResourcesConstraint());
        this.workers = new HashMap();
        for (Map.Entry<Types.WorkerSubType, Worker> entry : workers_.entrySet()) {
            Worker wkr = entry.getValue();
            if (!this.workers.containsKey((Object)wkr.type)) {
                this.workers.put(wkr.type, new HashMap());
            }
            if (this.workers.get((Object)wkr.type).containsKey((Object)wkr.subType)) {
                throw new Error("The subtype " + (Object)((Object)wkr.subType) + " is already defined for " + (Object)((Object)wkr.type));
            }
            this.workers.get((Object)wkr.type).put(wkr.subType, wkr);
        }
    }

    public HashMap<Types.WorkerSubType, Worker> getWorkers(Types.WorkerType wt) {
        if (this.workers.containsKey((Object)wt)) {
            return this.workers.get((Object)wt);
        }
        throw new Error("Attempt to get Worker list for " + (Object)((Object)wt) + " but no such worker type is defined");
    }

    @Override
    protected void initializeStructure() {
        for (HashMap<Types.WorkerSubType, Worker> wlist : this.workers.values()) {
            for (Worker wp : wlist.values()) {
                MatrixVariable newVariable = new MatrixVariable(-wp.getAnnualCost(), wp.lowerBound, wp.upperBound, wp.glpkBoundType, wp.glpkVariableType, this.matrix.numCols(), Types.ObjectiveType.PROFIT);
                newVariable.setTag(wp.subType.shortName);
                this.matrix.addVariable(newVariable);
                wp.registerParent(this);
                wp.registerVariable(newVariable, 0);
            }
        }
    }

    @Override
    protected void updateStructure() {
        for (HashMap<Types.WorkerSubType, Worker> wlist : this.workers.values()) {
            for (Worker wp : wlist.values()) {
                wp.updateStructure(this);
            }
        }
        this.structureUpdateDone();
    }

    public Map<Integer, LinkedHashMap<Object, Double>> getWorkload() {
        HashMap<Integer, LinkedHashMap<Object, Double>> result = new HashMap<Integer, LinkedHashMap<Object, Double>>();
        int numPeriods = this.getParent().numPeriods;
        CroppingComponent cropping = this.getParent().cropping;
        Location location = this.getParent().location();
        for (int periodicp = 0; periodicp < numPeriods; ++periodicp) {
            int p;
            int yr;
            Operation op;
            int o;
            int numops;
            List<Operation> cpOps;
            Crop.CropCopy cp;
            LinkedHashMap<Object, Double> totals = new LinkedHashMap<Object, Double>();
            totals.put(0, location.availableHours(periodicp));
            for (Types.WorkabilityType wkability : Types.WorkabilityType.values()) {
                HashMap<Types.WorkerType, Double> wkbltot = new HashMap<Types.WorkerType, Double>();
                for (CropYear cropyr : cropping.cropYears()) {
                    cp = cropping.getCrop(cropyr.base).getCopy(cropyr.copyYear);
                    cpOps = cp.operations();
                    numops = cpOps.size();
                    for (o = 0; o < numops; ++o) {
                        op = cpOps.get(o);
                        for (yr = 0; yr < 2; ++yr) {
                            p = periodicp + numPeriods * yr;
                            if (!(op.workability.percentHours <= wkability.percentHours) || !op.unfoldedAllowedSet().contains(p)) continue;
                            for (Types.WorkerType wktype : op.workerSet()) {
                                HashMap<Types.WorkerSubType, Worker> wlist = this.workers.get((Object)wktype);
                                double nworkers = 0.0;
                                for (Worker wp : wlist.values()) {
                                    nworkers += wp.getSolvedNumber();
                                }
                                double timetaken = op.workrate(location) * (double)op.numRequiredForWorkerType(wktype).intValue() * op.solvedArea(p) / nworkers;
                                if (wkbltot.containsKey((Object)wktype)) {
                                    timetaken += ((Double)wkbltot.get((Object)wktype)).doubleValue();
                                }
                                wkbltot.put(wktype, timetaken);
                            }
                        }
                    }
                }
                if (wkbltot.size() > 0) {
                    totals.put((Object)wkability, (Double)Collections.max(wkbltot.values()));
                    continue;
                }
                totals.put((Object)wkability, 0.0);
            }
            for (Types.WorkerType wktype : this.workers.keySet()) {
                double wkrtot = 0.0;
                HashMap<Types.WorkerSubType, Worker> wlist = this.workers.get((Object)wktype);
                for (CropYear cropyr : cropping.cropYears()) {
                    cp = cropping.getCrop(cropyr.base).getCopy(cropyr.copyYear);
                    cpOps = cp.operations();
                    numops = cpOps.size();
                    for (o = 0; o < numops; ++o) {
                        op = cpOps.get(o);
                        for (yr = 0; yr < 2; ++yr) {
                            p = periodicp + numPeriods * yr;
                            if (!op.unfoldedAllowedSet().contains(p) || !op.requiresWorker(wktype)) continue;
                            double nworkers = 0.0;
                            for (Worker wp : wlist.values()) {
                                nworkers += wp.getSolvedNumber();
                            }
                            wkrtot += op.workrate(location) * (double)op.numRequiredForWorkerType(wktype).intValue() * op.solvedArea(p) / nworkers;
                        }
                    }
                }
                totals.put((Object)wktype, wkrtot);
            }
            result.put(periodicp, totals);
        }
        return result;
    }

    public String printSolution(Farm model) {
        StringBuffer outstring = new StringBuffer();
        outstring.append("--- Workers ---\n");
        for (HashMap<Types.WorkerSubType, Worker> wlist : this.workers.values()) {
            for (Worker wp : wlist.values()) {
                outstring.append((Object)((Object)wp.subType) + ": " + MathPrint.f1.format(wp.getSolvedNumber()) + "\n");
            }
        }
        return outstring.toString();
    }

    public String printFixedCosts(Farm model) {
        double fc = 0.0;
        for (HashMap<Types.WorkerSubType, Worker> wlist : this.workers.values()) {
            for (Worker wp : wlist.values()) {
                fc += wp.getSolvedNumber() * wp.getAnnualCost();
            }
        }
        return "Fixed Costs: " + fc;
    }

    public final class ResourcesConstraint
    extends ConstraintBuilder {
        public ResourcesConstraint() {
            super(ConstraintBuilder.CBType.RESOURCES, ModelComponent.MCType.WORKERS);
        }

        public void build() {
            int numPeriods = WorkersComponent.this.getParent().numPeriods;
            CroppingComponent cropping = WorkersComponent.this.getParent().cropping;
            Location location = WorkersComponent.this.getParent().location();
            int row = WorkersComponent.this.matrix.numRows();
            MatrixRow rp = null;
            for (Types.WorkabilityType wkability : Types.WorkabilityType.values()) {
                for (Types.WorkerType wktype : WorkersComponent.this.workers.keySet()) {
                    HashMap wlist = (HashMap)WorkersComponent.this.workers.get((Object)wktype);
                    HashMap<Integer, MatrixRow> rowlist = new HashMap<Integer, MatrixRow>();
                    for (int p = 0; p < numPeriods * Farm.maxYears; ++p) {
                        int periodicp = Farm.wrapPeriod(p, numPeriods);
                        for (CropYear cropyr : cropping.cropYears()) {
                            Crop.CropCopy cp = cropping.getCrop(cropyr.base).getCopy(cropyr.copyYear);
                            List<Operation> cpOps = cp.operations();
                            int numops = cpOps.size();
                            for (int o = 0; o < numops; ++o) {
                                Operation op = cpOps.get(o);
                                if (!(op.workability.percentHours <= wkability.percentHours) || !op.unfoldedAllowedSet().contains(p) || !op.requiresWorker(wktype)) continue;
                                if (!rowlist.containsKey(periodicp)) {
                                    rp = new MatrixRow(0.0, 0.0, LPX.LPX_LO, row, constraintTag, "Hours_for_" + wktype.name + "_in_p_" + periodicp);
                                    WorkersComponent.this.matrix.addRow(rp);
                                    rowlist.put(periodicp, rp);
                                    ++row;
                                    double avail = location.availableHours(periodicp) * wkability.percentHours;
                                    for (Worker wp : wlist.values()) {
                                        rp.addElement(new MatrixElement(wp.getDependentColumn(0), avail));
                                    }
                                }
                                rp = (MatrixRow)rowlist.get(periodicp);
                                double required = op.workrate(location) * (double)op.numRequiredForWorkerType(wktype).intValue();
                                rp.addElement(new MatrixElement(op.getDependentColumn(p), -required));
                            }
                        }
                    }
                }
            }
        }
    }
}

