/*
 * Decompiled with CFR 0.152.
 */
package jfm.mou;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jfm.lp.ModelComponent;
import jfm.lp.Objective;
import jfm.model.Farm;
import jfm.model.Types;
import jfm.mou.FarmerMOUParser;
import jfm.mou.ObjectiveU;
import jfm.utils.JFMMath;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FarmerMOU {
    private final Map<Types.ObjectiveType, Double> rawWeights = new HashMap<Types.ObjectiveType, Double>();
    private final Map<Types.ObjectiveType, Double> weights = new HashMap<Types.ObjectiveType, Double>();
    private final Map<Types.ObjectiveType, ObjectiveU> objectives = new HashMap<Types.ObjectiveType, ObjectiveU>();

    public void addObjective(ObjectiveU obj) {
        Types.ObjectiveType t = obj.type;
        this.rawWeights.put(t, obj.rawWeight);
        this.objectives.put(t, obj);
        this.renormalizeWeights();
    }

    private void renormalizeWeights() {
        Double[] all = new Double[this.rawWeights.values().size()];
        this.rawWeights.values().toArray(all);
        double total = JFMMath.sum(all);
        for (Types.ObjectiveType type : this.rawWeights.keySet()) {
            this.weights.put(type, this.rawWeights.get((Object)type) / total);
        }
    }

    public double normalizedProfitWeight() {
        this.renormalizeWeights();
        return this.weights.get((Object)Types.ObjectiveType.PROFIT);
    }

    public static Document parseMOUDocument(String fileName) {
        File docFile = new File(fileName);
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(docFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Can't find the file " + fileName + " " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Problem parsing the file." + fileName + ": " + e.getLocalizedMessage());
        }
        return doc;
    }

    public static FarmerMOU fromXML(String fileName) {
        Document doc = FarmerMOU.parseMOUDocument(fileName);
        return FarmerMOU.fromXML(doc);
    }

    public static FarmerMOU fromXML(Document doc) {
        try {
            Element root = doc.getDocumentElement();
            FarmerMOUParser parser = new FarmerMOUParser(null);
            parser.parse(root);
            return (FarmerMOU)parser.getObject();
        }
        catch (XMLObjectException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
        catch (XMLSyntaxException e) {
            e.printStackTrace();
            throw new Error(e.getMessage());
        }
    }

    public static ModelComponent associatedModelComponent(Types.ObjectiveType objType, Farm farm) {
        ModelComponent.MCType mcType = ModelComponent.MCType.CROPPING;
        return farm.getModelComponent(mcType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void applyToFarm(FarmerMOU mou, Farm farm) {
        Map<Types.ObjectiveType, Objective> farmObjs = farm.getObjectives();
        Stack<Types.ObjectiveType> farmObjStack = new Stack<Types.ObjectiveType>();
        farmObjStack.addAll(farmObjs.keySet());
        try {
            for (Types.ObjectiveType type : mou.weights.keySet()) {
                if (!farmObjs.containsKey((Object)type)) {
                    throw new Error("Can't apply MOU to farm because ObjectiveType " + (Object)((Object)type) + " is missing ");
                }
                Objective theObj = farmObjs.get((Object)type);
                ObjectiveU objU = mou.objectives.get((Object)type);
                if (objU.isCurved) {
                    theObj.setScaleFactor(mou.weights.get((Object)type));
                    if (!objU.replacesObjective) throw new Error("Curved objective not replacing original .. should not happen");
                    Objective theCurvedObj = new Objective(FarmerMOU.associatedModelComponent(theObj.type, farm), Types.xmlToObjectiveType("curved" + type.xmlname), theObj, objU.xVals(), objU.yVals());
                    farm.addObjective(theCurvedObj);
                } else {
                    theObj.setScaleFactor(mou.weights.get((Object)type) * mou.objectives.get((Object)type).slope());
                }
                farmObjStack.remove((Object)type);
            }
            if (farmObjStack.size() <= 0 || farmObjStack.size() <= 1 && farmObjStack.pop() == Types.ObjectiveType.SOS2DUMMY) return;
            throw new Error("Some Objectives:  \n" + farmObjStack + " \n with unspecified weights when applying MOU");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Error(ex.getMessage());
        }
    }
}

