% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasi.R
\name{rscore}
\alias{rscore}
\title{Calculate the r1 or r2 score for a new observation in ones test data.}
\usage{
rscore(
  s_test_cur,
  y_class_cur,
  a_cur,
  z_cal,
  z_test,
  rscore_plus,
  r2_indicator
)
}
\arguments{
\item{s_test_cur}{The current ranking score from the test data to be evaluated.}

\item{y_class_cur}{The class label you want to generate the r-scores for.}

\item{a_cur}{The current protected group from the test data to be evaluated.}

\item{z_cal}{The calibration data set.}

\item{z_test}{The test data set.}

\item{rscore_plus}{Logical variable, TRUE/FALSE, that determines if the r-score or r-score plus is calculated.}

\item{r2_indicator}{Logical variable, TRUE/FALSE, that determines if the r1 or r2 score is calculated.}
}
\value{
The r-score corresponding to s_test_cur.
}
\description{
This function calculates an r-score for a given ranking score. It requires a calibration and testing dataset.
Both the r-score+ and r-score can be implemented.
}
\details{
Do not call this function externally. It is only meant to be called from within the fasi function.
}
\examples{
\donttest{
rscore(s_test_cur, y_class_cur, a_cur, z_cal, z_test, rscore_plus, r2_indicator)
}
}
\author{
Bradley Rava. PhD Candidate at the University of Southern California's Marshall School of Business.
Department of Data Sciences and Operations.
}
