
#' Foundations and Applications of Statistics
#' 
#' Data sets and utility functions to accompany \cite{Foundations and
#' Applications of Statistics: An Introduction Using R} by Randall Pruim.
#' 
#' @name fastR-package
#' @aliases fastR-package fastR
#' @docType package
#' @author Randall Pruim
#' 
#' Maintainer: Randall Pruim <rpruim@@calvin.edu>
#' @references R. Pruim, \cite{Foundations and Applicaitons of Statistics: An Introduction Using R}, AMS, 2011.
#' @keywords package 
#' @examples
#' 
#' require(fastR)
#' trellis.par.set(theme=col.fastR())
#' 

#' @import mosaic
#' @import mosaicData
#' @import lattice
#' @import grid
#' @importFrom grDevices as.graphicsAnnot colorRampPalette dev.interactive devAskNewPage 
#' @importFrom grDevices extendrange gray heat.colors
#' @importFrom graphics abline axis box boxplot lines mtext plot points
#' @importFrom stats coef cooks.distance deviance df.residual dnorm effects 
#' @importFrom stats fitted lm lm.influence model.frame nlm ppoints predict qnorm residuals rnorm terms weights
#' @importFrom utils file_test

NULL


