% Generated by roxygen2 (4.0.1): do not edit by hand
\name{geolm}
\alias{geolm}
\alias{to2d}
\title{Geometric representation of linear model}
\usage{
geolm(formula, data = parent.env(), type = "xz", version = 1,
  plot = TRUE, ...)

to2d(x, y, z, type = NULL, xas = c(0.4, -0.3), yas = c(1, 0), zas = c(0,
  1))
}
\arguments{
\item{formula}{a formula as used in \code{\link{lm}}.}

\item{data}{a data frame as in \code{\link{lm}}.}

\item{type}{character: indicating the type of projection to use to collapse
multi-dimensional data space into two dimensions of the display.}

\item{version}{an integer (currently \code{1} or \code{2}).  Which version
of the plot to display.}

\item{plot}{a logical: should the plot be displayed?}

\item{x,y,z}{numeric.}

\item{xas,yas,zas}{numeric vector of length 2 indicating the projection of
\code{c(1,0,0)}, \code{c(0,1,0)}, and \code{c(0,0,1)}.}

\item{\dots}{other arguments passed to \code{\link{lm}}}
}
\description{
\code{geolm} create a graphical representation of the fit of a linear model.
}
\examples{
geolm(pollution ~ location, data=airpollution)
geolm(distance ~ projectileWt, data=trebuchet2)
}
\author{
Randall Pruim
}
\seealso{
\code{\link{lm}}.
}
\keyword{stats}

