% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fasttext.R
\name{predict.supervised_model}
\alias{predict.supervised_model}
\title{Predict using a Previously Trained Model}
\usage{
\method{predict}{supervised_model}(object, newdata = character(),
  newdata_file = "", result_file = "", k = 1L, prob = FALSE, ...)
}
\arguments{
\item{object}{an object inheriting from \code{'fasttext'}.}

\item{newdata}{a character vector giving the new data.}

\item{newdata_file}{a character string giving the location of to the new data.}

\item{result_file}{a character string naming a file.}

\item{k}{an integer giving the number of labels to be returned.}

\item{prob}{a logical if true the probabilities are also returned.}

\item{...}{currently not used.}
}
\value{
\code{NULL} if a \code{'result_file'} is given otherwise 
        if \code{'prob'} is true a \code{data.frame} with the predicted labels 
        and the corresponding probabilities, if \code{'prob'} is false a 
        character vector with the predicted labels.
}
\description{
Predict values based on a previously trained model.
}
\examples{
\dontrun{
predict(object, newdata)
}
}

