% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plots.R
\name{volcano_plot}
\alias{volcano_plot}
\alias{plot.topic_model_de_analysis}
\alias{volcano_plotly}
\alias{volcano_plot_do_label_default}
\alias{volcano_plot_ggplot_call}
\alias{volcano_plot_ly_call}
\title{Volcano Plots for Visualizing Results of Differential Expression Analysis}
\usage{
volcano_plot(
  de,
  k,
  labels,
  do.label = volcano_plot_do_label_default,
  ymax = Inf,
  max.overlaps = Inf,
  plot.title = paste("topic", k),
  ggplot_call = volcano_plot_ggplot_call
)

\method{plot}{topic_model_de_analysis}(x, ...)

volcano_plotly(
  de,
  k,
  file,
  labels,
  ymax = Inf,
  width = 500,
  height = 500,
  plot.title = paste("topic", k),
  plot_ly_call = volcano_plot_ly_call
)

volcano_plot_do_label_default(lfc, z)

volcano_plot_ggplot_call(dat, plot.title, max.overlaps = Inf, font.size = 9)

volcano_plot_ly_call(dat, plot.title, width, height)
}
\arguments{
\item{de}{An object of class \dQuote{topic_model_de_analysis},
usually an output from \code{\link{de_analysis}}. It is better to
run \code{de_analysis} with \code{shrink.method = "ash"} so that
the points in the volcano plot can be coloured by their local false
sign rate (lfsr).}

\item{k}{The topic, selected by number or name.}

\item{labels}{Character vector specifying how the points in the
volcano plot are labeled. This should be a character vector with
one entry per LFC estimate (row of \code{de$postmean}). When not
specified, the row names of \code{de$postmean} are used. When
available. labels are added to the plot using
\code{\link[ggrepel]{geom_text_repel}}.}

\item{do.label}{The function used to deetermine which LFC estimates
to label. Replace \code{volcano_plot_do_label_default} with your
own function to customize the labeling of points in the volcano
plot.}

\item{ymax}{z-scores greater than \code{ymax} (in magnitude) are
shown as \code{max}. Setting \code{ymax} to a finite value can
improve the volcano plot when some z-scores are much larger (in
magnitude) than others.}

\item{max.overlaps}{Argument passed to
\code{\link[ggrepel]{geom_text_repel}}.}

\item{plot.title}{The title of the plot.}

\item{ggplot_call}{The function used to create the plot. Replace
\code{volcano_plot_ggplot_call} with your own function to customize
the appearance of the plot.}

\item{x}{An object of class \dQuote{topic_model_de_analysis},
usually an output from \code{\link{de_analysis}}.}

\item{\dots}{Additional arguments passed to \code{volcano_plot}.}

\item{file}{Save the interactive volcano plot to this HTML
file using \code{\link[htmlwidgets]{saveWidget}}.}

\item{width}{Width of the plot in pixels. Passed as argument
\dQuote{width} to \code{\link[plotly]{plot_ly}}.}

\item{height}{Height of the plot in pixels. Passed as argument
\dQuote{height} to \code{\link[plotly]{plot_ly}}.}

\item{plot_ly_call}{The function used to create the plot. Replace
\code{volcano_plot_ly_call} with your own function to customize
the appearance of the interactive plot.}

\item{lfc}{A vector of log-fold change estimates.}

\item{z}{A vector of z-scores of the same length as \code{lfc}.}

\item{dat}{A data frame passed as input to
\code{\link[ggplot2]{ggplot}}, containing, at a minimum, columns
\dQuote{f0}, \dQuote{postmean}, \dQuote{z}, \dQuote{zabs},
\dQuote{lfsr} and \dQuote{label}.}

\item{font.size}{Font size used in plot.}
}
\value{
A \code{ggplot} object or a \code{plotly} object.
}
\description{
Create a \dQuote{volcano} plot to visualize the
  results of a differential count analysis using a topic model. Here,
  the volcano plot is a scatterplot in which the posterior mean
  log-fold change (LFC), estimated by running the methods implemented
  in \code{\link{de_analysis}}, is plotted against the estimated
  z-score. Use \code{volcano_plotly} to create an interactive volcano
  plot.
}
\details{
Interactive volcano plots can be created using the
  \sQuote{plotly} package. The \dQuote{hover text} shows the label
  and detailed LFC statistics.
}
\examples{
# See help(de_analysis) for examples.

}
\seealso{
\code{\link{de_analysis}}
}
