% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.r
\name{rbind,GVector-method}
\alias{rbind,GVector-method}
\alias{rbind}
\title{Combine one or more GVectors}
\usage{
\S4method{rbind}{GVector}(..., deparse.level = 1)
}
\arguments{
\item{...}{One or more \code{GVector}s.}

\item{deparse.level}{See \code{\link[=rbind]{rbind()}}.}
}
\value{
A \code{GVector}.
}
\description{
\code{rbind()} combines two or more \code{GVector}s of the same type (points, lines, or polygons) and same coordinate reference system. You can speed operations by putting the vector that is largest in memory first in \code{rbind(...)}. If the \code{GVector}s have data tables, these will also be combined using \code{rbind()} if their column names and data types match.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Rivers vector
madRivers <- fastData("madRivers")

# Convert sf to a GVector
rivers <- fast(madRivers)

# Convert GVector to data.frame or data.table
as.data.frame(rivers)
as.data.table(rivers)

# Subset rivers vector
rivers1 <- rivers[1:2]
rivers2 <- rivers[10:11]

# Concatenate rivers
riversCombo <- rbind(rivers1, rivers2)
riversCombo

# Add columns
newCol <- data.frame(new = 1:11)
riversCol <- colbind(rivers, newCol)
riversCol

# Remove table
riversCopy <- rivers
riversCopy # has data table
riversCopy <- dropTable(riversCopy)
riversCopy # no data table

# Add a new table
newTable <- data.frame(num = 1:11, letters = letters[1:11])
addTable(riversCopy) <- newTable
riversCopy

}
}
\seealso{
\code{\link[=colbind]{colbind()}}, \code{\link[fasterRaster]{addTable<-}}, \code{\link[=dropTable]{dropTable()}}
}
