% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_mixed_df.R
\name{sim_mixed_df}
\alias{sim_mixed_df}
\title{Generate a mixed design from existing data}
\usage{
sim_mixed_df(
  data,
  sub_n = NULL,
  item_n = NULL,
  dv = "y",
  sub_id = "sub_id",
  item_id = "item_id"
)
}
\arguments{
\item{data}{the existing tbl}

\item{sub_n}{the number of subjects to simulate (if NULL, returns data for the same subjects)}

\item{item_n}{the number of items to simulate (if NULL, returns data for the same items)}

\item{dv}{the column name or index containing the DV}

\item{sub_id}{the column name or index for the subject IDs}

\item{item_id}{the column name or index for the item IDs}
}
\value{
a tbl
}
\description{
\code{sim_mixed_df()} produces a data table with the same distributions of 
by-subject and by-item random intercepts as an existing data table.
}
\examples{
\donttest{sim_mixed_df(faceratings, 10, 10, "rating", "rater_id", "face_id")}
}
