% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\docType{data}
\name{Error}
\alias{Error}
\title{Error class}
\arguments{
\item{behavior}{Behavior of the error. See Details}

\item{message_template}{A message template. optional. use whisker
templating. names to use are: reason, status, message. use in template
like \code{\{\{reason\}\}}, \code{\{\{status\}\}}, and
\code{\{\{message\}\}}}

\item{call.}{(logical) indicating if the call should become part
of the error message. Default: \code{FALSE}}
}
\description{
Error class
}
\details{
\strong{Methods}
\itemize{
  \item \code{do(response, mssg)}
  Execute condition, whether it be message, warning, or error.
}
}
\section{behavior parameter options}{

\itemize{
 \item stop - stop on error
 \item warning - warning on error
 \item message - message on error
}
}
\examples{
Error$new()

if (requireNamespace("crul")) {
 library("crul")
 res <- HttpClient$new("https://httpbin.org/status/418")$get()

 # stop
 (x <- Error$new(behavior = "stop"))
 \dontrun{x$do(res)}

 # warn
 (x <- Error$new(behavior = "warning"))
 x$do(res)

 # do vs. do_verbose
 x <- HTTPRequestURITooLong$new(behavior = "stop")
 res <- HttpClient$new("https://httpbin.org/status/414")$get()
 \dontrun{
 http414(res)
 ## with template
 http414(res, message_template = "{{status}}\\n  --> {{reason}}")
 x$do(res)
 x$do_verbose(res)
 }

 # service unavailable
 x <- HTTPServiceUnavailable$new(behavior = "stop")
 res <- HttpClient$new("https://httpbin.org/status/503")$get()
 \dontrun{
 x$do(res)
 x$do_verbose(res)
 }

 # message template
 y <- Error$new(message_template = "{{reason}} ............ {{status}}")
 res <- HttpClient$new("https://httpbin.org/status/418")$get()
 \dontrun{
 y$do(res)
 }

 yy <- Error$new(message_template = "{{status}}\\n  --> {{reason}}")
 \dontrun{
 yy$do(res)
 }

 ## with verbose message
 yy <- HTTPBadGateway$new(
   message_template = "HTTP({{status}}): {{reason}}\\n  {{message}}"
 )
 \dontrun{
 yy$do_verbose(res)
 }
}
}
\seealso{
\code{\link[fauxpas]{http}}, \code{\link[fauxpas]{Error-Classes}}
}
\keyword{datasets}

