% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Var.y.R
\name{Var.y}
\alias{Var.y}
\alias{Var.e}
\title{Sampling Variance estimates}
\usage{
Var.y(y, S, Var.e = NULL)
}
\arguments{
\item{y}{\code{\link{fdata}} class object.}

\item{S}{Smoothing matrix calculated by \code{\link{S.basis}} or
\code{\link{S.NW}} functions.}

\item{Var.e}{Error Variance Estimates. If \code{Var.e}=NULL, Var.e is
calculated.}
}
\value{
Var.y: returns the sampling variance of the functional data. Var.e:
returns the sampling error variance of the functional data.
}
\description{
Sampling variance or error variance estimates for regression estimates.
}
\examples{
a1<-seq(0,1,by=.01)
a2=rnorm(length(a1),sd=0.2)
f1<-(sin(2*pi*a1))+rnorm(length(a1),sd=0.2)
nc<-50
np<-length(f1)
tt=1:101
mdata<-matrix(NA,ncol=np,nrow=nc)
for (i in 1:nc) mdata[i,]<- (sin(2*pi*a1))+rnorm(length(a1),sd=0.2)
mdata<-fdata(mdata,tt)
S=S.NW(tt,h=0.15)
var.e<-Var.e(mdata,S)
var.y<-Var.y(mdata,S)
var.y2<-Var.y(mdata,S,var.e) #the same
}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), \emph{
Functional Data Analysis}, 2nd ed., Springer, New York.
}
\seealso{
See Also as \code{\link{Var.e}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
