% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kernel.R
\name{Kernel}
\alias{Kernel}
\alias{Ker.norm}
\alias{Ker.cos}
\alias{Ker.epa}
\alias{Ker.tri}
\alias{Ker.quar}
\alias{Ker.unif}
\title{Symmetric Smoothing Kernels.}
\usage{
Kernel(u, type.Ker = "Ker.norm")
}
\arguments{
\item{u}{Data.}

\item{type.Ker}{Type of Kernel. By default normal kernel.}
}
\value{
Returns symmetric kernel.
}
\description{
Represent symmetric smoothing kernels:: normal, cosine, triweight, quartic
and uniform.
}
\details{
\tabular{ll}{ \tab Ker.norm=dnorm(u)\cr \tab
Ker.cos=ifelse(abs(u)<=1,pi/4*(cos(pi*u/2)),0)\cr \tab
Ker.epa=ifelse(abs(u)<=1,3/4*(1-u^2),0)\cr \tab
Ker.tri=ifelse(abs(u)<=1,35/32*(1-u^2)^3,0)\cr \tab
Ker.quar=ifelse(abs(u)<=1,15/16*(1-u^2)^2,0)\cr \tab
Ker.unif=ifelse(abs(u)<=1,1/2,0)\cr }

Type of kernel: \tabular{ll}{ \tab Normal Kernel: \code{Ker.norm}\cr \tab
Cosine Kernel: \code{Ker.cos}\cr \tab Epanechnikov Kernel: \code{Ker.epa}\cr
\tab Triweight Kernel: \code{Ker.tri}\cr \tab Quartic Kernel:
\code{Ker.quar}\cr \tab Uniform Kernel: \code{Ker.unif}\cr }
}
\examples{
y=qnorm(seq(.1,.9,len=100))
a<-Kernel(u=y)
b<-Kernel(type.Ker="Ker.tri",u=y)
c=Ker.cos(y)
}
\references{
Ferraty, F. and Vieu, P. (2006). \emph{Nonparametric functional
data analysis.} Springer Series in Statistics, New York. \cr

Hardle, W. \emph{Applied Nonparametric Regression}. Cambridge University
Press, 1994.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{kernel}
