% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPCquantile.R
\name{FPCquantile}
\alias{FPCquantile}
\title{Conditional Quantile estimation with functional covariates}
\usage{
FPCquantile(Lx, Lt_x, y, outQ = c(0.1, 0.25, 0.5, 0.75, 0.9),
  optns_x = NULL, isNewSub = NULL)
}
\arguments{
\item{Lx}{A length n list of predictor function where x[[i]] is the row vector of measurements for ith subject, i=1,...,n}

\item{Lt_x}{A length n list where the observations of x are taken, t_x[[i]] is a row vector of time points where x[[i]] are observed, i=1,...,n}

\item{y}{A 1*n vector for scalar response y. y[i] is the response value for the ith subject, i = 1,...,n.}

\item{outQ}{A vector of desired quantile levels with default value outQ = c(0.1, 0.25, 0.5, 0.75, 0.9).}

\item{optns_x}{A list of options for predictor x with control parameters specified by list(name=value) with default NA. See function FPCA for details.}

\item{isNewSub}{A 1*n vector of 0s or 1s, where n is the total count of subjects. 0 denotes the corresponding subject is only used for training and 1 denotes the corresponding subject is only used for prediction. (default: 0's)}
}
\value{
A list of the following
\item{pred_quantile}{A matrix of n*length(outQ) where the the first nn (number of 0s in \code{isNewSub}) rows containing fitted  conditional quantiles of Y corresponding to the training subjects, and the last n-nn rows containing predicted conditional quantiles of Y corresponding to the subjects isNewSub ==1.}
\item{pred_CDF}{A matrix of n*100. The ith row contains the fitted or predicted conditional distribution function \eqn{F(y|X_i)}, evaluated at an equally spaced grid of 100 points.}
\item{b}{A matrix of 50*(K+1) contains the coefficient functions, defined as \eqn{F(y|X) = g(\sum_(k=0)^K b_k(y)\xi_k)}, see equation (5) in the paper for details, where K is the number of components selected to expand the predictor functions X, and \eqn{\xi_k} is the kth principal component score.}
}
\description{
Main function to implement conditional Quantile estimation with functional covariates and scalar response. The method includes 3 steps: 
1) FPCA using the PACE method for X(t_x)
2) Computation of the conditional distribution function through a functional generalized linear model.
3) Prediction of quantiles for given predictor values
}
\examples{
set.seed(10)

n = 200
npred = 50
m = 50
xi <- Wiener(n, 0:m/m)

x=list()
t_x=list()
y=numeric(n)
for(i in 1:n){
 t_x = c(t_x,list(0:m/m))
 x = c(x,list(xi[i,]))
 y[i] = 5*rnorm(1)+2*sum(xi[i,])
}

outQ = c(0.1,0.25,0.5,0.75,0.9,0.95)
isNewSub = c(rep(0,150),rep(1,50))
qtreg = FPCquantile(x, t_x, y, outQ,optns_x = NULL,isNewSub)

}
\references{
\cite{Chen, K., Müller, H.G. (2011). Conditional quantile analysis when covariates are functions, with application to growth data. 
J. Royal Statistical Society B 74, 67-89}
}
