% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic_mlpcr_regression.R
\name{elastic.mlpcr.regression}
\alias{elastic.mlpcr.regression}
\title{Elastic Multinomial Logisitc Prinipcal Component Regression}
\usage{
elastic.mlpcr.regression(
  f,
  y,
  time,
  pca.method = "combined",
  no = 5,
  smooth_data = FALSE,
  sparam = 25
)
}
\arguments{
\item{f}{matrix (\eqn{N} x \eqn{M}) of \eqn{M} functions with \eqn{N} samples}

\item{y}{vector of size \eqn{M} labels}

\item{time}{vector of size \eqn{N} describing the sample points}

\item{pca.method}{string specifing pca method (options = "combined",
"vert", or "horiz", default = "combined")}

\item{no}{scalar specifify number of principal components (default=5)}

\item{smooth_data}{smooth data using box filter (default = F)}

\item{sparam}{number of times to apply box filter (default = 25)}
}
\value{
Returns a mlpcr object containing
\item{alpha}{model intercept}
\item{b}{regressor vector}
\item{y}{label vector}
\item{Y}{Coded labels}
\item{warp_data}{fdawarp object of aligned data}
\item{pca}{pca object of principal components}
\item{Loss}{logistic loss}
\item{pca.method}{string specifing pca method used}
}
\description{
This function identifies a multinomial logistic regression model with phase-variability
using elastic pca
}
\references{
J. D. Tucker, J. R. Lewis, and A. Srivastava, “Elastic
 Functional Principal Component Regression,” Statistical Analysis and Data
 Mining, 10.1002/sam.11399, 2018.
}
\keyword{alignment}
\keyword{regression}
\keyword{srvf}
