% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_boxplot.R
\name{curve_boxplot}
\alias{curve_boxplot}
\title{Curve Boxplot}
\usage{
curve_boxplot(
  x,
  alpha = 0.05,
  range = 1,
  what = c("stats", "plot", "plot+stats"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{fdacurve} typically produced by \code{\link[=curve_srvf_align]{curve_srvf_align()}}}

\item{alpha}{A numeric value specifying the quantile value. Defaults to
\eqn{0.05} which uses the \eqn{95\%} quantile.}

\item{range}{A positive numeric value specifying how far the plot whiskers
extend out from the box. The whiskers extend to the most extreme data point
which is no more than \code{range} times the interquartile range from the box.
Defaults to \code{1.0}.}

\item{what}{A string specifying what the function should return. Choices are
\code{"plot"}, \code{"stats"} or \code{"plot+stats"}. Defaults to \code{"plot"}.}

\item{...}{Unused here.}
}
\value{
If \code{what} contains \code{stats}, a list containing the computed statistics
necessary for drawing the boxplot. Otherwise, the function simply draws the
boxplot and no object is returned.
}
\description{
This function computes the required statistics for building up a boxplot of
the aligned curve data. The computed boxplot focuses on the aligned curves.
}
\details{
The function returns optionally an object of class either
\code{curvebox}
}
\examples{
\dontrun{
out <- curve_srvf_align(beta[, , 1, ], ms="median")
curve_boxplot(out, what = "stats")
}
}
