% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refactoring.R
\name{warp_srvf}
\alias{warp_srvf}
\title{Applies a warping function to a given SRVF}
\usage{
warp_srvf(qfun, gamfun, betafun = NULL)
}
\arguments{
\item{qfun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the SRVF of an underlying
curve at \eqn{s}.}

\item{gamfun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of a diffeomorphic warping
function at \eqn{s}.}

\item{betafun}{A function that takes a numeric vector \eqn{s} of values in
\eqn{[0, 1]} as input and returns the values of the underlying curve at
\eqn{s}. Defaults to \code{NULL}.}
}
\value{
A function that takes a numeric vector \eqn{s} of values in \eqn{[0,
 1]} as input and returns the values of the warped SRVF.
}
\description{
Applies a warping function to a given SRVF
}
\examples{
q <- curve2srvf(beta[, , 1, 1])
warp_srvf(q, get_identity_warping())
}
