% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{bootstrap}
\alias{bootstrap}
\title{Bootstrap evaluation}
\usage{
bootstrap(
  methods,
  x,
  y,
  eval = ifelse(is.factor(y), "accuracy", "r2"),
  nruns = 10,
  seed = NULL,
  methodparameters = NULL,
  names = NULL,
  ...
)
}
\arguments{
\item{methods}{The classification or regression method to be evaluated.}

\item{x}{The dataset (description/predictors), a \code{matrix} or \code{data.frame}.}

\item{y}{The target (class labels or numeric values), a \code{factor} or \code{vector}.}

\item{eval}{The evaluation function.}

\item{nruns}{The number of bootstrap runs.}

\item{seed}{A specified seed for random number generation (useful for testing different method with the same bootstap samplings).}

\item{methodparameters}{Method parameters (if null tuning is done by cross-validation).}

\item{names}{Method names.}

\item{...}{Other specific parameters for the leaning method.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation a classification or regression method using bootstrap approach.
}
\examples{
require ("datasets")
data (iris)
# One method, one evaluation criterion
bootstrap (NB, iris [, -5], iris [, 5], seed = 0)
# One method, two evaluation criteria
bootstrap (NB, iris [, -5], iris [, 5], eval = c ("accuracy", "kappa"), seed = 0)
# Three methods, two evaluation criteria
bootstrap (c (NB, LDA, LR), iris [, -5], iris [, 5], eval = c ("accuracy", "kappa"), seed = 0)
# List of methods in a variable
classif = c (NB, LDA, LR)
bootstrap (classif, iris [, -5], iris [, 5], eval = c ("accuracy", "kappa"), seed = 0,
           names = c ("NB", "LDA", "LR"))
# List of strings (method names)
classif = c ("NB", "LDA", "LR")
bootstrap (classif, iris [, -5], iris [, 5], eval = c ("accuracy", "kappa"), seed = 0)
}
\seealso{
\code{\link{evaluate}}, \code{\link{evaluation}}, \code{\link{bootstrap.curves}}
}
