% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{MLPREG}
\alias{MLPREG}
\title{Multi-Layer Perceptron Regression}
\usage{
MLPREG(
  x,
  y,
  size = 2:(ifelse(is.vector(x), 2, ncol(x))),
  decay = 10^(-3:-1),
  params = NULL,
  tune = FALSE,
  ...
)
}
\arguments{
\item{x}{Predictor \code{matrix}.}

\item{y}{Response \code{vector}.}

\item{size}{The size of the hidden layer (if a vector, cross-over validation is used to chose the best size).}

\item{decay}{The decay (between 0 and 1) of the backpropagation algorithm (if a vector, cross-over validation is used to chose the best size).}

\item{params}{Object containing the parameters. If given, it replaces \code{size} and \code{decay}.}

\item{tune}{If true, the function returns paramters instead of a classification model.}

\item{...}{Other parameters.}
}
\value{
The classification model, as an object of class \code{\link{model-class}}.
}
\description{
This function builds a regression model using MLP.
}
\examples{
\dontrun{
require (datasets)
data (trees)
MLPREG (trees [, -3], trees [, 3])
}
}
\seealso{
\code{\link[nnet]{nnet}}
}
