% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{predict.meanshift}
\alias{predict.meanshift}
\title{Predict function for MeanShift}
\usage{
\method{predict}{meanshift}(object, newdata, ...)
}
\arguments{
\item{object}{The classification model (created by \code{\link{MEANSHIFT}}).}

\item{newdata}{A new dataset (a \code{data.frame}), with same variables as the learning dataset.}

\item{...}{Other parameters.}
}
\description{
Return the closest MeanShift cluster for a new dataset.
}
\examples{
\dontrun{
require (datasets)
data (iris)
d = splitdata (iris, 5)
model = MEANSHIFT (d$train.x, bandwidth = .75)
predict (model, d$test.x)
}
}
\seealso{
\code{\link{MEANSHIFT}}
}
