% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{query.words}
\alias{query.words}
\title{Word query}
\usage{
query.words(wordvectors, origin, sub = NULL, add = NULL, nres = 5, lang = "en")
}
\arguments{
\item{wordvectors}{The vectorized words}

\item{origin}{The query (character).}

\item{sub}{Words to be substrated to the origin.}

\item{add}{Words to be Added to the origin.}

\item{nres}{The number of results.}

\item{lang}{The language of the words (NULL if no stemming).}
}
\value{
The Words the most similar to the query.
}
\description{
Search for words similar to the query.
}
\examples{
\dontrun{
text = loadtext ("http://mattmahoney.net/dc/text8.zip")
words = vectorize.words (text, minphrasecount = 50)
query.words (words, origin = "paris", sub = "france", add = "germany")
query.words (words, origin = "berlin", sub = "germany", add = "france")
query.words (words, origin = "new_zealand")
}
}
\seealso{
\code{\link{vectorize.words}}, \code{\link[text2vec]{sim2}}
}
