\name{make.fdt.multiple}
\alias{make.fdt.multiple}

\title{
  A function which makes the table using the number of interval classes, 
  a method used for breaks, and choose the endpoint
}

\description{
  A function which makes the table by using parameters defining the number of
  interval classes, the method used for breaks (\dQuote{Sturges}, \dQuote{Scott} or \dQuote{FD}), 
  and the closure of the interval class endpoints being \samp{left} or \samp{right}.
}

\usage{
  make.fdt.multiple(x,
                    k,
                    breaks = c('Sturges', 'Scott', 'FD'),
                    right)
}

\arguments{
  \item{x}{A \code{data.frame} or \code{matrix} object containing at last one numeric column.}
  \item{k}{Number of class intervals.}
  \item{breaks}{Method to determine number of classes, c(\dQuote{Sturges}, \dQuote{Scott}, \dQuote{FD}).}
  \item{right}{Intervals right open (default = \code{FALSE}).}
}

\details{
  A function which makes the table by using parameters defining the number of
  interval classes, the method used for breaks (\dQuote{Sturges}, \dQuote{Scott} or \dQuote{FD})
  and the closure of the interval class endpoints being \samp{left} or \samp{right}.
}

\value{
  The function \code{make.fdt.multiple} returns a list with the slots:
  \item{table}{A \code{data.frame} storing the \samp{fdt}}
  \item{breaks}{A \code{vector} of length 4 storing \samp{start}, \samp{end},
    \samp{h} and \samp{right} of the \samp{fdt} generated by this method}
  \item{data}{A vector of the data \samp{x} provided}
}

\seealso{
 \code{\link[base]{table}} and \code{\link[base]{cut}} provided by \pkg{base} package.
}

\author{
  Jos Cludio Faria (\email{joseclaudio.faria@gmail.com})\cr
  Enio Jelihovschi (\email{eniojelihovs@gmail.com})\cr
}

\note{
  This function is mainly for internal use in the \pkg{fdth} package, and may
  not remain available (unless we see a good reason).
}
