% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{feat_pacf}
\alias{feat_pacf}
\title{Partial autocorrelation-based features}
\usage{
feat_pacf(x, .period = 1, lag_max = NULL, ...)
}
\arguments{
\item{x}{a univariate time series}

\item{.period}{The seasonal period (optional)}

\item{lag_max}{maximum lag at which to calculate the acf. The default is
\code{max(.period, 10L)} for \code{feat_acf}, and \code{max(.period, 5L)} for \code{feat_pacf}}

\item{...}{Further arguments passed to \code{\link[stats:acf]{stats::acf()}} or \code{\link[stats:pacf]{stats::pacf()}}}
}
\value{
A vector of 3 values: Sum of squared of first 5
partial autocorrelation coefficients of the original series, first differenced
series and twice-differenced series.
For seasonal data, the partial autocorrelation coefficient at the first seasonal
lag is also returned.
}
\description{
Computes various measures based on partial autocorrelation coefficients of the
original series, first-differenced series and second-differenced series.
}
\author{
Thiyanga Talagala
}
