% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{gg_subseries}
\alias{gg_subseries}
\title{Seasonal subseries plots}
\usage{
gg_subseries(data, y = NULL, period = NULL, ...)
}
\arguments{
\item{data}{A tidy time series object (tsibble)}

\item{y}{The variable to plot (a bare expression). If NULL, it will
automatically selected from the data.}

\item{period}{The seasonal period to display.}

\item{...}{Additional arguments passed to geom_line()}
}
\value{
A ggplot object showing a seasonal subseries plot of a time series.
}
\description{
A seasonal subseries plot facets the time series by each season in the
seasonal period. These facets form smaller time series plots consisting of
data only from that season. If you had several years of monthly data, the
resulting plot would show a separate time series plot for each month. The
first subseries plot would consist of only data from January. This case is
given as an example below.
}
\details{
The horizontal lines are used to represent the mean of each facet, allowing
easy identification of seasonal differences between seasons. This plot is
particularly useful in identifying changes in the seasonal pattern over time.

similar to a seasonal plot (\code{\link[=gg_season]{gg_season()}}), and
}
\examples{
library(tsibble)
library(dplyr)
tsibbledata::aus_retail \%>\%
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) \%>\%
  gg_subseries(Turnover)

}
\references{
Hyndman and Athanasopoulos (2019) Forecasting: principles and practice,
3rd edition, OTexts: Melbourne, Australia. https://OTexts.com/fpp3/
}
