% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{gg_arma}
\alias{gg_arma}
\title{Plot characteristic ARMA roots}
\usage{
gg_arma(data)
}
\arguments{
\item{data}{A mable containing models with AR and/or MA roots.}
}
\value{
A ggplot object the characteristic roots from ARMA components.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
\code{gg_arma()} was soft deprecated in feasts 0.4.2. Please use \code{ggtime::gg_arma()} instead.

Produces a plot of the inverse AR and MA roots of an ARIMA model.
Inverse roots outside the unit circle are shown in red.

Only models which compute ARMA roots can be visualised with this function.
That is to say, the \code{glance()} of the model contains \code{ar_roots} and \code{ma_roots}.
}
\examples{
if (requireNamespace("fable", quietly = TRUE)) {
library(fable)
library(tsibble)
library(dplyr)

tsibbledata::aus_retail \%>\%
  filter(
    State == "Victoria",
    Industry == "Cafes, restaurants and catering services"
  ) \%>\%
  model(ARIMA(Turnover ~ pdq(0,1,1) + PDQ(0,1,1))) \%>\%
  gg_arma()
}
}
