% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featurefinder.r
\name{saveTree}
\alias{saveTree}
\title{saveTree}
\usage{
saveTree(data, vars, expr, i, outputPath, varname, mainfaclev,
  treeGenerationMinBucket, ...)
}
\arguments{
\item{data}{A dataframe containing the residual and some predictors}

\item{vars}{A list of candidate predictors}

\item{expr}{A expression to be modelled by the RPART tree}

\item{i}{An integer corresponding to the factor level}

\item{outputPath}{The output directory}

\item{varname}{A string corresponding to the name of the factor variable being analysed}

\item{mainfaclev}{A level of the mainfac factor}

\item{treeGenerationMinBucket}{Minimum size for tree generation}

\item{...}{and parameters to be passed through}
}
\value{
A tree object
}
\description{
Generate a residual tree on a subset of the data specified by the factor level mainfaclev (main factor level)
}
\examples{

require(featurefinder)
data(examples)
fit1=saveTree(data,vars,expr,i,outputPath=tempdir(),runname,mainfaclevels[1],
     treeGenerationMinBucket)
}
\keyword{saveTree}
