% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible_point.R
\name{feasible_point}
\alias{feasible_point}
\title{Find Feasible Point in Ellipse Overlap}
\usage{
feasible_point(ell, ...)
}
\arguments{
\item{ell}{a list of at least two (non degenerate) ellipses; see
\code{\link{wrangle_ellipse}}.}

\item{...}{additional arguments to be passed to internal functions.}
}
\value{
\code{feasible_point} returns an object of \code{\link[base]{class}}
  "\code{feasible_point}" with the following entries
  \item{x }{ An interior point.}
  \item{distance }{ A data.frame with the ellipse specific distances.}
  \item{optim }{ The final internal optimization value.}
  \item{call }{ The matched call.}
}
\description{
\code{feasible_point} will find a point in the interior of the intersection
of two or more fully specified ellipses. If the intersections is empty
\code{NA} is returned.
}
\details{
\code{feasible_point} will find a point in the interior of the intersection
of two or more fully specified ellipses \code{ell}. If the intersections is
empty \code{NA} is returned.
}
\examples{
# two dimensional ellipses
e1 <- list("c" = c(1,2), "P" = matrix(c(2,0,0,1), ncol = 2), "r" = 3)
e2 <- list("c" = c(0,0), "S" = matrix(c(1, 0.2, 0.2, 2), ncol = 2), "r" = 1)

# find point in intersection
feasible_point(list(e1, e2))

# make new ellipse
e3 <- list("c" = c(2,2), "P" = matrix(c(1,0,0,1), ncol = 2), "r" = 0.5)

# now there is no overlap
feasible_point(list(e1, e2, e3))

}
\seealso{
\code{\link{wrangle_ellipse}} for detailed on ellipse
parameterization.
}
