% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{view_on_volatility}
\alias{view_on_volatility}
\alias{view_on_volatility.default}
\alias{view_on_volatility.matrix}
\alias{view_on_volatility.xts}
\alias{view_on_volatility.tbl_df}
\title{Views on Volatility}
\usage{
view_on_volatility(x, vol)

\method{view_on_volatility}{default}(x, vol)

\method{view_on_volatility}{matrix}(x, vol)

\method{view_on_volatility}{xts}(x, vol)

\method{view_on_volatility}{tbl_df}(x, vol)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{vol}{A \code{double} for the target volatility structure
of the series in \code{x}.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Helper to construct views on volatility.
}
\examples{
library(ggplot2)

# Invariant
ret <- diff(log(EuStockMarkets))
n   <- nrow(ret)

# Expected a volatility 30\% higher than historical average
vol <- apply(ret, 2, stats::sd) * 1.3

# Prior Probabilities
prior <- rep(1 / n, n)

# Views
views <- view_on_volatility(x = ret, vol = vol)
views

# Optimization
ep <- entropy_pooling(p = prior, Aeq = views$Aeq, beq = views$beq, solver = "nlminb")
autoplot(ep)

# Desired volatility
vol

# Posterior volatility matches very closely with the desired volatility
sqrt(diag(ffp_moments(x = ret, p = ep)$sigma))
}
