% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_resources.R
\docType{methods}
\name{fhir_crack}
\alias{fhir_crack}
\alias{fhir_crack,ANY,fhir_design-method}
\alias{fhir_crack,fhir_design-method}
\alias{fhir_crack,ANY,fhir_table_description-method}
\alias{fhir_crack,fhir_table_description-method}
\alias{fhir_crack,ANY,list-method}
\alias{fhir_crack,list-method}
\title{Flatten list of FHIR bundles}
\usage{
fhir_crack(
  bundles,
  design,
  sep = NULL,
  remove_empty_columns = NULL,
  brackets = NULL,
  verbose = 2,
  data.table = FALSE
)

\S4method{fhir_crack}{ANY,fhir_design}(
  bundles,
  design,
  sep = NULL,
  remove_empty_columns = NULL,
  brackets = NULL,
  verbose = 2,
  data.table = FALSE
)

\S4method{fhir_crack}{ANY,fhir_table_description}(
  bundles,
  design,
  sep = NULL,
  remove_empty_columns = NULL,
  brackets = NULL,
  verbose = 2,
  data.table = FALSE
)

\S4method{fhir_crack}{ANY,list}(
  bundles,
  design,
  sep = NULL,
  remove_empty_columns = NULL,
  brackets = NULL,
  verbose = 2,
  data.table = FALSE
)
}
\arguments{
\item{bundles}{A FHIR search result as returned by \code{\link[=fhir_search]{fhir_search()}}.}

\item{design}{A \linkS4class{fhir_design} or \linkS4class{fhir_table_description} object. See \code{\link[=fhir_design]{fhir_design()}}/\code{\link[=fhir_table_description]{fhir_table_description()}}
and the corresponding vignette (\code{vignette("flattenResources", package ="fhircrackr")}) for a more detailed explanation and
comprehensive examples of both.}

\item{sep}{Optional. A character vector of length ones to separate pasted multiple entries which will overwrite the \code{sep} defined in
\code{design}. If \code{sep = NULL}, it is looked up in \code{design}, where the default is \code{" "}.}

\item{remove_empty_columns}{Optional. Remove empty columns? Logical scalar which will overwrite the \code{rm_empty_cols} defined in
\code{design}. If \code{remove_empty_columns = NULL}, it is looked up in \code{design}, where the default is \code{FALSE}.}

\item{brackets}{Optional. A character vector of length two defining the brackets surrounding indices for multiple entries, e.g. \code{c( "<", ">")},
which will overwrite the \code{brackets} defined in \code{design}. If \code{brackets = NULL}, it is looked up in \code{design}, where the default is \code{character(0)},
i.e. no indices are added to multiple entries. Empty strings (\code{""}) are not allowed.}

\item{verbose}{An integer vector of length one.  If 0, nothing is printed, if 1, only finishing message is printed, if > 1,
extraction progress will be printed. Defaults to 2.}

\item{data.table}{A logical vector of length one. If it is set to TRUE the fhir_crack-function returns a data.table, otherwise a data.frame.
Defaults to FALSE.}
}
\value{
If a \linkS4class{fhir_design} was used, the result is a list of data.frames, i.e. a \linkS4class{fhir_df_list} object, or a list of data.tables,
i.e. a \linkS4class{fhir_dt_list} object. If a \linkS4class{fhir_table_description} was used, the result is a single data.frame/data.table.
}
\description{
Converts a \linkS4class{fhir_bundle_list} (the result of \code{\link[=fhir_search]{fhir_search()}} to a list of data.frames/data.tables,
i.e. a \linkS4class{fhir_df_list}/\linkS4class{fhir_dt_list} if a \linkS4class{fhir_design} is given in the argument \code{design}.
Creates a single data.frame/data.table, if only a \linkS4class{fhir_table_description} is given in the argument \code{design}.
}
\examples{
#unserialize example bundle
bundles <- fhir_unserialize(medication_bundles)


###Example 1###
#Extract just one resource type

#define attributes to extract
medications <- fhir_table_description(
   resource = "MedicationStatement",
   cols = c(
			    	MS.ID              = "id",
				    STATUS.TEXT        = "text/status",
			    	STATUS             = "status",
			    	MEDICATION.SYSTEM  = "medicationCodeableConcept/coding/system",
			    	MEDICATION.CODE    = "medicationCodeableConcept/coding/code",
			    	MEDICATION.DISPLAY = "medicationCodeableConcept/coding/display",
			    	DOSAGE             = "dosage/text",
			    	PATIENT            = "subject/reference",
			    	LAST.UPDATE        = "meta/lastUpdated"
	    	),
	 style = fhir_style(
 			sep = " ",
	        	brackets = c("[", "]"),
    		    rm_empty_cols= FALSE
    		)
)

med_df <- fhir_crack(bundles = bundles, design = medications)

head(med_df) #data.frame


###Example 2###
#extract more resource types

patients <- fhir_table_description(
   resource = "Patient"
)

design <- fhir_design(medications, patients)

df_list <- fhir_crack(bundles = bundles, design = design)

#list of data.frames/fhir_df_list
head(df_list$medications)
head(df_list$patients)

#The design that was used can be extracted from a fhir_df_list
fhir_design(df_list)

}
\seealso{
\itemize{
\item Downloading bundles from a FHIR server: \code{\link[=fhir_search]{fhir_search()}}
\item Creating designs/table_descriptions: \code{\link[=fhir_table_description]{fhir_table_description()}} and \code{\link[=fhir_design]{fhir_design()}}
\item Dealing with multiple entries: \code{\link[=fhir_melt]{fhir_melt()}},  \code{\link[=fhir_rm_indices]{fhir_rm_indices()}}
}
}
