% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/respak.R
\name{osp}
\alias{osp}
\title{Occluded Surface Packing (OSP)}
\usage{
osp(file)
}
\arguments{
\item{file}{a SRF File (.srf) generated by 'occluded_surface' in fibos_files folder.}
}
\value{
A table containing:
\describe{
\item{\code{Resnum}}{residue id.}
\item{\code{Resname}}{residue name.}
\item{\code{OS}}{the summed areas of dots in residue.}
\item{\code{`os*[1-raylen]`}}{'OS' areas weighted by (1-raylen). Raylen is the average lengths of normals normalized by 2.8 \eqn{\text{\AA}} (water diameter). So, raylen is a value between 0 and 1. A raylen close to 1 indicates worse packaging, and the 'OS' will be reduced.}
\item{\code{OSP}}{average occluded surface packing value (OSP) by residue.}
}
}
\description{
{Implements the 'occluded surface' packing density metric (OSP) averaged by residue, as described in (Fleming and Richards 2000).}
}
\examples{
\donttest{
library(fibos)

#Configure the Environment
fibos_config() 

# Calculate FIBOS per atom and create .srf files in fibos_files folder
pdb_fibos <- occluded_surface("1ptx", method = "FIBOS")
# Calculate OSP metric per residue from .srf file in fibos_files folder
pdb_osp <- osp(fs::path("fibos_files","prot_1ptx.srf"))
}
}
\references{
Fleming PJ, Richards FM (2000). "Protein packing: Dependence on protein size, secondary structure and amino acid composition." \url{doi:10.1006/jmbi.2000.3750}

Pattabiraman N, Ward KB, Fleming PJ (1995). "Occluded molecular surface: Analysis of protein packing." \url{doi:10.1002/jmr.300080603}

Soares HHM, Romanelli JPR, Fleming PJ, da Silveira CH (2024). "bioRxiv, 2024.11.01.621530." \url{doi:10.1101/2024.11.01.621530}
}
\seealso{
\code{\link[=occluded_surface]{occluded_surface()}}
}
\author{
Herson Soares

Joao Romanelli

Patrick Fleming

Carlos Silveira.
}
