% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fiftystater.R
\name{fifty_states_inset_boxes}
\alias{fifty_states_inset_boxes}
\alias{fifty_states_inset_boxes_data}
\title{Add inset box borders}
\usage{
fifty_states_inset_boxes()
}
\value{
A ggplot2 layer object with path data to draw the inset border boxes
}
\description{
Border boxes for the insets of Alaska and Hawaii in
\code{\link{fifty_states}} can be added to the map with this function.
}
\details{
Adding the result of this function to your ggplot will add a layer with
border boxes to highlight the insets. It draws data from the package data
object
\code{fifty_states_inset_boxes_data} and creates a layer to plot the borders
 with \code{\link[ggplot2]{annotate}}.
}
\examples{
if(require("mapproj") && require("ggplot2")) {
  crimes <- data.frame(state = tolower(rownames(USArrests)), USArrests)
  ggplot(crimes, aes(fill = UrbanPop, map_id = state)) +
    geom_map(map = fifty_states) +
    expand_limits(x = fifty_states$long, y = fifty_states$lat) +
    coord_map() + fifty_states_inset_boxes()
}
}

