% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{CreateDirsIfNotThere}
\alias{CreateDirsIfNotThere}
\title{Create a directory if it doesn't already exist.}
\usage{
CreateDirsIfNotThere(dir.names)
}
\arguments{
\item{dir.names}{The name of the directories, specified via relative or
absolute paths.}
}
\value{
Invisibly, a vector with a \code{TRUE} for each time a directory was
actually created and a \code{FALSE} otherwise.
}
\description{
Given the name of a (potential) directory, if that directory does not already
exist, create it.
}
\examples{
setwd(tempdir())
CreateDirsIfNotThere(c("mydir", "yourdir"))
RemoveDirs(c("mydir", "yourdir"))
}
