% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{MakeExtName}
\alias{MakeExtName}
\title{Ensure a file name has the intended extension.}
\usage{
MakeExtName(string, ext, replace = FALSE)
}
\arguments{
\item{string}{The intended file name.}

\item{ext}{The intended file extension (with or without the ".").}

\item{replace}{If the file has an extension already, replace it (or append
the new extension name)?}
}
\value{
A string: the file name in your intended form.
}
\description{
Say you want to ensure a name is fit to be the name of a csv file. Then, if
the input doesn't end with ".csv", this function will tack ".csv" onto the
end of it.
}
\examples{
MakeExtName("abc.csv", "csv")
MakeExtName("abc", "csv")
MakeExtName("abc.csv", "pdf")
MakeExtName("abc.csv", "pdf", replace = TRUE)
}
